package editor;

import game.CustomImageDataII;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GoalSetupWizard extends JPanel {
	
//	private CustomAnimationPanel cap;
	private JCheckBox passThru;
	private JCheckBox showCommentary;
	private BackgroundPanel cap;
	private JDialog parent;
	
	private boolean wasCancelled = true;
	
	public GoalSetupWizard(JDialog theParent) {
		
		parent = theParent;
		
//		cap = new CustomAnimationPanel(theParent, "", "Goal");
		
		cap = new BackgroundPanel(theParent, "", true);
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(1, 2));
		
		mainPanel.add(cap);
		
		JPanel rightSidePanel = new JPanel();
		rightSidePanel.setLayout(new GridLayout(3, 1));
		
		rightSidePanel.add(new JPanel());
		
		passThru = new JCheckBox("should be pass-through?");
		JPanel passThruPanel = new JPanel(new FlowLayout());
		passThruPanel.add(passThru);
		rightSidePanel.add(passThruPanel);
		
		showCommentary = new JCheckBox("goal should enable commentary?");
		JPanel commentaryPanel = new JPanel(new FlowLayout());
		commentaryPanel.add(showCommentary);
		rightSidePanel.add(commentaryPanel);
		
		mainPanel.add(rightSidePanel);
		
		
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 5));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				cancelWasClicked();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		wasCancelled = true;
	}
	
	
	public GoalSetupWizard(JDialog theParent, CustomImageDataII [] cutscene, boolean thePassThruFlag, boolean theEnableCutscenesFlag) {

		parent = theParent;
		
//		cap = new CustomAnimationPanel(theParent, "", "Goal", cutscene);
		cap = new BackgroundPanel(theParent, "", true, cutscene);
		
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(1, 2));
		
		mainPanel.add(cap);
		
		JPanel rightSidePanel = new JPanel();
		rightSidePanel.setLayout(new GridLayout(3, 1));
		
		rightSidePanel.add(new JPanel());
		
		passThru = new JCheckBox("should be pass-through?", thePassThruFlag);
		JPanel passThruPanel = new JPanel(new FlowLayout());
		passThruPanel.add(passThru);
		rightSidePanel.add(passThruPanel);
		
			
		
		showCommentary = new JCheckBox("goal should enable commentary?", theEnableCutscenesFlag);
		JPanel commentaryPanel = new JPanel(new FlowLayout());
		commentaryPanel.add(showCommentary);
		rightSidePanel.add(commentaryPanel);
		
		mainPanel.add(rightSidePanel);
		
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new GridLayout(1, 5));
		
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				cancelWasClicked();
			}
		});
		bottomPanel.add(cancelButton);
		
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		bottomPanel.add(new JPanel());
		
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				okWasClicked();
			}
		});
		bottomPanel.add(okButton);
		
		this.add(bottomPanel, BorderLayout.SOUTH);
		
		wasCancelled = true;
		
	}
	
	
	public BackgroundPanel getAnimPanel() {
		return cap;
	}
	
	public boolean shouldBePassThru() {
		return passThru.isSelected();
	}
	
	public boolean shouldEnableCommentary() {
		return showCommentary.isSelected();
	}
	
	
	
	public static void main(String [] args) {
		
		
		JDialog frame = new JDialog();
		
		GoalSetupWizard panel = new GoalSetupWizard(frame);
		frame.setContentPane(panel);
		
		frame.setModal(true);
		
		frame.setSize(new Dimension(900, 700));
		
		frame.setVisible(true);
		
		
		frame.dispose();
		
	}
	
	
	public void cancelWasClicked() {
		wasCancelled = true;
		parent.dispose();
	}
	
	
	public void okWasClicked() {
		
		if(cap.getListModel().size() == 0) {
			int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to have a goal with no cutscene?","Confirm no cutscene", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			if(result == JOptionPane.YES_OPTION) {
				this.parent.dispose();
				return;
			} else
				return;
		}
		
		ListedImage li = null;
		for(int i = 0; i < cap.getListModel().size(); i++) {
			
			li = (ListedImage) cap.getListModel().get(i);
			
			if(li.getFileName() == null || li.getFileName().trim().equals("blank")) {
				JOptionPane.showMessageDialog(this, "One or more of the images is blank!","Error", JOptionPane.WARNING_MESSAGE);
				return;
			}
			
		}
		
		wasCancelled = false;
		
		parent.dispose();
		
		
		
	}
	
}
